varying vec3 v_normal;
varying vec4 _color;

uniform sampler2D texture;
vec3 packFloatToVec3i(const float value)
{
	const vec3 bitSh = vec3( 256.0 * 256.0, 256.0, 1.0);
	const vec3 bitMsk = vec3( 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);
	vec3 res = fract(value * bitSh);
	res -= res.xxy * bitMsk;
	return res;
}

void main()
{
	int draw = 0;
	vec4 color = texture2D(texture, gl_TexCoord[0].xy).rgba;
	color.rgb *= vec3(color.a);
	vec3 luminosity = vec3(0.30, 0.59, 0.11);
	float lum = dot(luminosity, color.rgb);
	float _color_a = _color.a;
	if(_color_a < 0.0 ) _color_a = 0.0;

		vec4 levels = vec4(0.9,0.75,0.5,0.25);
	levels = levels/vec4(4.0*_color_a);
	float v = gl_FragCoord.s;
	float h = gl_FragCoord.t;
	float value = 0.0;

	float col = 1.0;
	gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);

	if (lum < levels.r)
		{
		value = float(int((fract(v/2.0))+(fract(h/2.0))));
		col *= value;
	}

	if (lum < levels.g)
		{
		value = float(int((fract(v+v/2.0))+(fract(h+h/2.0))));
		col *= value;
	}

	if (lum < levels.b)
		{
		value = float(int((fract(v+v+v/2.0))+(fract(h+h/2.0))));
		col *= value;
	}

	if (lum < levels.a)
		{
		value = float(int((fract(v+v/2.0))+(fract(h+h+h/2.0))));
		col *= value;
	}


	if(col<=0.9)
		discard;
	else  {
		vec2 xadd = vec2(0.05,0.0);
		vec2 yadd = vec2(0.0,0.05);
		float cx1 = texture2D(texture, gl_TexCoord[0].xy+xadd).r;
		float cx2 = texture2D(texture, gl_TexCoord[0].xy-xadd).r;
		float cy1 = texture2D(texture, gl_TexCoord[0].xy+yadd).r;
		float cy2 = texture2D(texture, gl_TexCoord[0].xy-yadd).r;

		vec3 nAdd = vec3(cx2 - cx1, cy2 - cy1,0);
		//nAdd = vec3(0,0,0);
		gl_FragColor = vec4(vec3(0.5)*(v_normal+vec3(1.0)+vec3(nAdd)),1);

	}
}

